package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EncryptionConfigProperty {

  def apply(
    resources: Option[List[String]] = None,
    provider: Option[AnyRef] = None
  ): software.amazon.awscdk.services.eks.CfnCluster.EncryptionConfigProperty =
    (new software.amazon.awscdk.services.eks.CfnCluster.EncryptionConfigProperty.Builder)
      .resources(resources.map(_.asJava).orNull)
      .provider(provider.orNull)
      .build()
}
