package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EksOptimizedImageProps {

  def apply(
    cpuArch: Option[software.amazon.awscdk.services.eks.CpuArch] = None,
    kubernetesVersion: Option[String] = None,
    nodeType: Option[software.amazon.awscdk.services.eks.NodeType] = None
  ): software.amazon.awscdk.services.eks.EksOptimizedImageProps =
    (new software.amazon.awscdk.services.eks.EksOptimizedImageProps.Builder)
      .cpuArch(cpuArch.orNull)
      .kubernetesVersion(kubernetesVersion.orNull)
      .nodeType(nodeType.orNull)
      .build()
}
