package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CommonClusterOptions {

  def apply(
    version: software.amazon.awscdk.services.eks.KubernetesVersion,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    vpcSubnets: Option[List[_ <: software.amazon.awscdk.services.ec2.SubnetSelection]] = None,
    outputConfigCommand: Option[Boolean] = None,
    outputClusterName: Option[Boolean] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    clusterName: Option[String] = None,
    securityGroup: Option[software.amazon.awscdk.services.ec2.ISecurityGroup] = None
  ): software.amazon.awscdk.services.eks.CommonClusterOptions =
    (new software.amazon.awscdk.services.eks.CommonClusterOptions.Builder)
      .version(version)
      .role(role.orNull)
      .vpcSubnets(vpcSubnets.map(_.asJava).orNull)
      .outputConfigCommand(outputConfigCommand.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .outputClusterName(outputClusterName.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .vpc(vpc.orNull)
      .clusterName(clusterName.orNull)
      .securityGroup(securityGroup.orNull)
      .build()
}
