package io.burkard.cdk.services.eks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFargateProfile {

  def apply(
    internalResourceId: String,
    podExecutionRoleArn: String,
    selectors: List[_],
    clusterName: String,
    subnets: Option[List[String]] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    fargateProfileName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.eks.CfnFargateProfile =
    software.amazon.awscdk.services.eks.CfnFargateProfile.Builder
      .create(stackCtx, internalResourceId)
      .podExecutionRoleArn(podExecutionRoleArn)
      .selectors(selectors.asJava)
      .clusterName(clusterName)
      .subnets(subnets.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .fargateProfileName(fargateProfileName.orNull)
      .build()
}
