package io.burkard.cdk.services.efs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMountTargetProps {

  def apply(
    fileSystemId: String,
    subnetId: String,
    securityGroups: List[String],
    ipAddress: Option[String] = None
  ): software.amazon.awscdk.services.efs.CfnMountTargetProps =
    (new software.amazon.awscdk.services.efs.CfnMountTargetProps.Builder)
      .fileSystemId(fileSystemId)
      .subnetId(subnetId)
      .securityGroups(securityGroups.asJava)
      .ipAddress(ipAddress.orNull)
      .build()
}
