package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoadBalancerProperty {

  def apply(
    containerName: Option[String] = None,
    containerPort: Option[Number] = None,
    targetGroupArn: Option[String] = None,
    loadBalancerName: Option[String] = None
  ): software.amazon.awscdk.services.ecs.CfnTaskSet.LoadBalancerProperty =
    (new software.amazon.awscdk.services.ecs.CfnTaskSet.LoadBalancerProperty.Builder)
      .containerName(containerName.orNull)
      .containerPort(containerPort.orNull)
      .targetGroupArn(targetGroupArn.orNull)
      .loadBalancerName(loadBalancerName.orNull)
      .build()
}
