package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AddAutoScalingGroupCapacityOptions {

  def apply(
    machineImageType: Option[software.amazon.awscdk.services.ecs.MachineImageType] = None,
    spotInstanceDraining: Option[Boolean] = None,
    topicEncryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    canContainersAccessInstanceRole: Option[Boolean] = None
  ): software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions =
    (new software.amazon.awscdk.services.ecs.AddAutoScalingGroupCapacityOptions.Builder)
      .machineImageType(machineImageType.orNull)
      .spotInstanceDraining(spotInstanceDraining.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .topicEncryptionKey(topicEncryptionKey.orNull)
      .canContainersAccessInstanceRole(canContainersAccessInstanceRole.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
