package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FirelensOptions {

  def apply(
    configFileValue: String,
    enableEcsLogMetadata: Option[Boolean] = None,
    configFileType: Option[software.amazon.awscdk.services.ecs.FirelensConfigFileType] = None
  ): software.amazon.awscdk.services.ecs.FirelensOptions =
    (new software.amazon.awscdk.services.ecs.FirelensOptions.Builder)
      .configFileValue(configFileValue)
      .enableEcsLogMetadata(enableEcsLogMetadata.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .configFileType(configFileType.orNull)
      .build()
}
