package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NamedPackageOptions {

  def apply(
    version: Option[List[String]] = None,
    serviceRestartHandles: Option[List[_ <: software.amazon.awscdk.services.ec2.InitServiceRestartHandle]] = None
  ): software.amazon.awscdk.services.ec2.NamedPackageOptions =
    (new software.amazon.awscdk.services.ec2.NamedPackageOptions.Builder)
      .version(version.map(_.asJava).orNull)
      .serviceRestartHandles(serviceRestartHandles.map(_.asJava).orNull)
      .build()
}
