package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InitFileAssetOptions {

  def apply(
    assetHashType: Option[software.amazon.awscdk.AssetHashType] = None,
    readers: Option[List[_ <: software.amazon.awscdk.services.iam.IGrantable]] = None,
    assetHash: Option[String] = None,
    serviceRestartHandles: Option[List[_ <: software.amazon.awscdk.services.ec2.InitServiceRestartHandle]] = None,
    bundling: Option[software.amazon.awscdk.BundlingOptions] = None,
    mode: Option[String] = None,
    followSymlinks: Option[software.amazon.awscdk.SymlinkFollowMode] = None,
    exclude: Option[List[String]] = None,
    owner: Option[String] = None,
    base64Encoded: Option[Boolean] = None,
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None,
    group: Option[String] = None
  ): software.amazon.awscdk.services.ec2.InitFileAssetOptions =
    (new software.amazon.awscdk.services.ec2.InitFileAssetOptions.Builder)
      .assetHashType(assetHashType.orNull)
      .readers(readers.map(_.asJava).orNull)
      .assetHash(assetHash.orNull)
      .serviceRestartHandles(serviceRestartHandles.map(_.asJava).orNull)
      .bundling(bundling.orNull)
      .mode(mode.orNull)
      .followSymlinks(followSymlinks.orNull)
      .exclude(exclude.map(_.asJava).orNull)
      .owner(owner.orNull)
      .base64Encoded(base64Encoded.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .ignoreMode(ignoreMode.orNull)
      .group(group.orNull)
      .build()
}
