package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CommonNetworkAclEntryOptions {

  def apply(
    cidr: software.amazon.awscdk.services.ec2.AclCidr,
    traffic: software.amazon.awscdk.services.ec2.AclTraffic,
    ruleNumber: Number,
    networkAclEntryName: Option[String] = None,
    direction: Option[software.amazon.awscdk.services.ec2.TrafficDirection] = None,
    ruleAction: Option[software.amazon.awscdk.services.ec2.Action] = None
  ): software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions =
    (new software.amazon.awscdk.services.ec2.CommonNetworkAclEntryOptions.Builder)
      .cidr(cidr)
      .traffic(traffic)
      .ruleNumber(ruleNumber)
      .networkAclEntryName(networkAclEntryName.orNull)
      .direction(direction.orNull)
      .ruleAction(ruleAction.orNull)
      .build()
}
