package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPrefixListProps {

  def apply(
    addressFamily: String,
    maxEntries: Number,
    prefixListName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    entries: Option[List[_]] = None
  ): software.amazon.awscdk.services.ec2.CfnPrefixListProps =
    (new software.amazon.awscdk.services.ec2.CfnPrefixListProps.Builder)
      .addressFamily(addressFamily)
      .maxEntries(maxEntries)
      .prefixListName(prefixListName)
      .tags(tags.map(_.asJava).orNull)
      .entries(entries.map(_.asJava).orNull)
      .build()
}
