package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClientVpnRouteProps {

  def apply(
    destinationCidrBlock: String,
    clientVpnEndpointId: String,
    targetVpcSubnetId: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnClientVpnRouteProps =
    (new software.amazon.awscdk.services.ec2.CfnClientVpnRouteProps.Builder)
      .destinationCidrBlock(destinationCidrBlock)
      .clientVpnEndpointId(clientVpnEndpointId)
      .targetVpcSubnetId(targetVpcSubnetId)
      .description(description.orNull)
      .build()
}
