package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCapacityReservationProps {

  def apply(
    availabilityZone: String,
    instanceType: String,
    instanceCount: Number,
    instancePlatform: String,
    ebsOptimized: Option[Boolean] = None,
    tagSpecifications: Option[List[_]] = None,
    endDate: Option[String] = None,
    instanceMatchCriteria: Option[String] = None,
    outPostArn: Option[String] = None,
    ephemeralStorage: Option[Boolean] = None,
    tenancy: Option[String] = None,
    placementGroupArn: Option[String] = None,
    endDateType: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnCapacityReservationProps =
    (new software.amazon.awscdk.services.ec2.CfnCapacityReservationProps.Builder)
      .availabilityZone(availabilityZone)
      .instanceType(instanceType)
      .instanceCount(instanceCount)
      .instancePlatform(instancePlatform)
      .ebsOptimized(ebsOptimized.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .tagSpecifications(tagSpecifications.map(_.asJava).orNull)
      .endDate(endDate.orNull)
      .instanceMatchCriteria(instanceMatchCriteria.orNull)
      .outPostArn(outPostArn.orNull)
      .ephemeralStorage(ephemeralStorage.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .tenancy(tenancy.orNull)
      .placementGroupArn(placementGroupArn.orNull)
      .endDateType(endDateType.orNull)
      .build()
}
