package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Subnet {

  def apply(
    internalResourceId: String,
    vpcId: String,
    cidrBlock: String,
    availabilityZone: String,
    mapPublicIpOnLaunch: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.Subnet =
    software.amazon.awscdk.services.ec2.Subnet.Builder
      .create(stackCtx, internalResourceId)
      .vpcId(vpcId)
      .cidrBlock(cidrBlock)
      .availabilityZone(availabilityZone)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
