package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Connections {

  def apply(
    peer: Option[software.amazon.awscdk.services.ec2.IPeer] = None,
    securityGroups: Option[List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup]] = None,
    defaultPort: Option[software.amazon.awscdk.services.ec2.Port] = None
  ): software.amazon.awscdk.services.ec2.Connections =
    software.amazon.awscdk.services.ec2.Connections.Builder
      .create()
      .peer(peer.orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .defaultPort(defaultPort.orNull)
      .build()
}
