package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PublicSubnet {

  def apply(
    internalResourceId: String,
    vpcId: Option[String] = None,
    mapPublicIpOnLaunch: Option[Boolean] = None,
    cidrBlock: Option[String] = None,
    availabilityZone: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.PublicSubnet =
    software.amazon.awscdk.services.ec2.PublicSubnet.Builder
      .create(stackCtx, internalResourceId)
      .vpcId(vpcId.orNull)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .cidrBlock(cidrBlock.orNull)
      .availabilityZone(availabilityZone.orNull)
      .build()
}
