package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OnDemandOptionsRequestProperty {

  def apply(
    capacityReservationOptions: Option[software.amazon.awscdk.services.ec2.CfnEC2Fleet.CapacityReservationOptionsRequestProperty] = None,
    minTargetCapacity: Option[Number] = None,
    allocationStrategy: Option[String] = None,
    singleInstanceType: Option[Boolean] = None,
    singleAvailabilityZone: Option[Boolean] = None,
    maxTotalPrice: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty =
    (new software.amazon.awscdk.services.ec2.CfnEC2Fleet.OnDemandOptionsRequestProperty.Builder)
      .capacityReservationOptions(capacityReservationOptions.orNull)
      .minTargetCapacity(minTargetCapacity.orNull)
      .allocationStrategy(allocationStrategy.orNull)
      .singleInstanceType(singleInstanceType.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .singleAvailabilityZone(singleAvailabilityZone.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .maxTotalPrice(maxTotalPrice.orNull)
      .build()
}
