package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NetworkAclProps {

  def apply(
    vpc: software.amazon.awscdk.services.ec2.IVpc,
    networkAclName: Option[String] = None,
    subnetSelection: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None
  ): software.amazon.awscdk.services.ec2.NetworkAclProps =
    (new software.amazon.awscdk.services.ec2.NetworkAclProps.Builder)
      .vpc(vpc)
      .networkAclName(networkAclName.orNull)
      .subnetSelection(subnetSelection.orNull)
      .build()
}
