package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptionsBase {

  def apply(
    deleteOnTermination: Option[Boolean] = None,
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase =
    (new software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase.Builder)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
