package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VolumeAttributes {

  def apply(
    volumeId: String,
    availabilityZone: String,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.ec2.VolumeAttributes =
    (new software.amazon.awscdk.services.ec2.VolumeAttributes.Builder)
      .volumeId(volumeId)
      .availabilityZone(availabilityZone)
      .encryptionKey(encryptionKey.orNull)
      .build()
}
