package io.burkard.cdk.services.dynamodb

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SSESpecificationProperty {

  def apply(
    sseEnabled: Boolean,
    kmsMasterKeyId: Option[String] = None,
    sseType: Option[String] = None
  ): software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty =
    (new software.amazon.awscdk.services.dynamodb.CfnTable.SSESpecificationProperty.Builder)
      .sseEnabled(sseEnabled)
      .kmsMasterKeyId(kmsMasterKeyId.orNull)
      .sseType(sseType.orNull)
      .build()
}
