package io.burkard.cdk.services.dynamodb

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CapacityAutoScalingSettingsProperty {

  def apply(
    minCapacity: Number,
    maxCapacity: Number,
    targetTrackingScalingPolicyConfiguration: software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty,
    seedCapacity: Option[Number] = None
  ): software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty =
    (new software.amazon.awscdk.services.dynamodb.CfnGlobalTable.CapacityAutoScalingSettingsProperty.Builder)
      .minCapacity(minCapacity)
      .maxCapacity(maxCapacity)
      .targetTrackingScalingPolicyConfiguration(targetTrackingScalingPolicyConfiguration)
      .seedCapacity(seedCapacity.orNull)
      .build()
}
