package io.burkard.cdk.services.dlm

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ShareRuleProperty {

  def apply(
    targetAccounts: Option[List[String]] = None,
    unshareInterval: Option[Number] = None,
    unshareIntervalUnit: Option[String] = None
  ): software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ShareRuleProperty =
    (new software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.ShareRuleProperty.Builder)
      .targetAccounts(targetAccounts.map(_.asJava).orNull)
      .unshareInterval(unshareInterval.orNull)
      .unshareIntervalUnit(unshareIntervalUnit.orNull)
      .build()
}
