package io.burkard.cdk.services.databrew

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StatisticsConfigurationProperty {

  def apply(
    includedStatistics: Option[List[String]] = None,
    overrides: Option[List[_]] = None
  ): software.amazon.awscdk.services.databrew.CfnJob.StatisticsConfigurationProperty =
    (new software.amazon.awscdk.services.databrew.CfnJob.StatisticsConfigurationProperty.Builder)
      .includedStatistics(includedStatistics.map(_.asJava).orNull)
      .overrides(overrides.map(_.asJava).orNull)
      .build()
}
