package io.burkard.cdk.services.databrew

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FilesLimitProperty {

  def apply(
    maxFiles: Number,
    order: Option[String] = None,
    orderedBy: Option[String] = None
  ): software.amazon.awscdk.services.databrew.CfnDataset.FilesLimitProperty =
    (new software.amazon.awscdk.services.databrew.CfnDataset.FilesLimitProperty.Builder)
      .maxFiles(maxFiles)
      .order(order.orNull)
      .orderedBy(orderedBy.orNull)
      .build()
}
