package io.burkard.cdk.services.databrew

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnJob {

  def apply(
    internalResourceId: String,
    name: String,
    roleArn: String,
    `type`: String,
    dataCatalogOutputs: Option[List[_]] = None,
    projectName: Option[String] = None,
    maxCapacity: Option[Number] = None,
    recipe: Option[software.amazon.awscdk.services.databrew.CfnJob.RecipeProperty] = None,
    jobSample: Option[software.amazon.awscdk.services.databrew.CfnJob.JobSampleProperty] = None,
    validationConfigurations: Option[List[_]] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    logSubscription: Option[String] = None,
    datasetName: Option[String] = None,
    outputs: Option[List[_]] = None,
    profileConfiguration: Option[software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty] = None,
    databaseOutputs: Option[List[_]] = None,
    encryptionKeyArn: Option[String] = None,
    encryptionMode: Option[String] = None,
    maxRetries: Option[Number] = None,
    outputLocation: Option[software.amazon.awscdk.services.databrew.CfnJob.OutputLocationProperty] = None,
    timeout: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.databrew.CfnJob =
    software.amazon.awscdk.services.databrew.CfnJob.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .roleArn(roleArn)
      .`type`(`type`)
      .dataCatalogOutputs(dataCatalogOutputs.map(_.asJava).orNull)
      .projectName(projectName.orNull)
      .maxCapacity(maxCapacity.orNull)
      .recipe(recipe.orNull)
      .jobSample(jobSample.orNull)
      .validationConfigurations(validationConfigurations.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .logSubscription(logSubscription.orNull)
      .datasetName(datasetName.orNull)
      .outputs(outputs.map(_.asJava).orNull)
      .profileConfiguration(profileConfiguration.orNull)
      .databaseOutputs(databaseOutputs.map(_.asJava).orNull)
      .encryptionKeyArn(encryptionKeyArn.orNull)
      .encryptionMode(encryptionMode.orNull)
      .maxRetries(maxRetries.orNull)
      .outputLocation(outputLocation.orNull)
      .timeout(timeout.orNull)
      .build()
}
