package io.burkard.cdk.cxapi

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpcSubnet {

  def apply(
    subnetId: String,
    routeTableId: String,
    availabilityZone: String,
    cidr: Option[String] = None
  ): software.amazon.awscdk.cxapi.VpcSubnet =
    (new software.amazon.awscdk.cxapi.VpcSubnet.Builder)
      .subnetId(subnetId)
      .routeTableId(routeTableId)
      .availabilityZone(availabilityZone)
      .cidr(cidr.orNull)
      .build()
}
