package io.burkard.cdk.services.customerprofiles

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SourceFlowConfigProperty {

  def apply(
    connectorType: String,
    sourceConnectorProperties: software.amazon.awscdk.services.customerprofiles.CfnIntegration.SourceConnectorPropertiesProperty,
    connectorProfileName: Option[String] = None,
    incrementalPullConfig: Option[software.amazon.awscdk.services.customerprofiles.CfnIntegration.IncrementalPullConfigProperty] = None
  ): software.amazon.awscdk.services.customerprofiles.CfnIntegration.SourceFlowConfigProperty =
    (new software.amazon.awscdk.services.customerprofiles.CfnIntegration.SourceFlowConfigProperty.Builder)
      .connectorType(connectorType)
      .sourceConnectorProperties(sourceConnectorProperties)
      .connectorProfileName(connectorProfileName.orNull)
      .incrementalPullConfig(incrementalPullConfig.orNull)
      .build()
}
