package io.burkard.cdk.core

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TagProps {

  def apply(
    priority: Option[Number] = None,
    applyToLaunchedInstances: Option[Boolean] = None,
    excludeResourceTypes: Option[List[String]] = None,
    includeResourceTypes: Option[List[String]] = None
  ): software.amazon.awscdk.TagProps =
    (new software.amazon.awscdk.TagProps.Builder)
      .priority(priority.orNull)
      .applyToLaunchedInstances(applyToLaunchedInstances.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .excludeResourceTypes(excludeResourceTypes.map(_.asJava).orNull)
      .includeResourceTypes(includeResourceTypes.map(_.asJava).orNull)
      .build()
}
