package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResourceProps {

  def apply(
    region: Option[String] = None,
    account: Option[String] = None,
    physicalName: Option[String] = None,
    environmentFromArn: Option[String] = None
  ): software.amazon.awscdk.ResourceProps =
    (new software.amazon.awscdk.ResourceProps.Builder)
      .region(region.orNull)
      .account(account.orNull)
      .physicalName(physicalName.orNull)
      .environmentFromArn(environmentFromArn.orNull)
      .build()
}
