package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LazyListValueOptions {

  def apply(
    displayHint: Option[String] = None,
    omitEmpty: Option[Boolean] = None
  ): software.amazon.awscdk.LazyListValueOptions =
    (new software.amazon.awscdk.LazyListValueOptions.Builder)
      .displayHint(displayHint.orNull)
      .omitEmpty(omitEmpty.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
