package io.burkard.cdk.core

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileFingerprintOptions {

  def apply(
    followSymlinks: Option[software.amazon.awscdk.SymlinkFollowMode] = None,
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None,
    exclude: Option[List[String]] = None,
    extraHash: Option[String] = None
  ): software.amazon.awscdk.FileFingerprintOptions =
    (new software.amazon.awscdk.FileFingerprintOptions.Builder)
      .followSymlinks(followSymlinks.orNull)
      .ignoreMode(ignoreMode.orNull)
      .exclude(exclude.map(_.asJava).orNull)
      .extraHash(extraHash.orNull)
      .build()
}
