package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileAssetLocation {

  def apply(
    bucketName: String,
    s3ObjectUrl: String,
    httpUrl: String,
    objectKey: String
  ): software.amazon.awscdk.FileAssetLocation =
    (new software.amazon.awscdk.FileAssetLocation.Builder)
      .bucketName(bucketName)
      .s3ObjectUrl(s3ObjectUrl)
      .httpUrl(httpUrl)
      .objectKey(objectKey)
      .build()
}
