package io.burkard.cdk.core

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DeploymentTargetsProperty {

  def apply(
    accounts: Option[List[String]] = None,
    organizationalUnitIds: Option[List[String]] = None
  ): software.amazon.awscdk.CfnStackSet.DeploymentTargetsProperty =
    (new software.amazon.awscdk.CfnStackSet.DeploymentTargetsProperty.Builder)
      .accounts(accounts.map(_.asJava).orNull)
      .organizationalUnitIds(organizationalUnitIds.map(_.asJava).orNull)
      .build()
}
