package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWaitCondition {

  def apply(
    internalResourceId: String,
    count: Option[Number] = None,
    handle: Option[String] = None,
    timeout: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.CfnWaitCondition =
    software.amazon.awscdk.CfnWaitCondition.Builder
      .create(stackCtx, internalResourceId)
      .count(count.orNull)
      .handle(handle.orNull)
      .timeout(timeout.orNull)
      .build()
}
