package io.burkard.cdk.core

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStackSetProps {

  def apply(
    stackSetName: String,
    permissionModel: String,
    callAs: Option[String] = None,
    executionRoleName: Option[String] = None,
    capabilities: Option[List[String]] = None,
    autoDeployment: Option[software.amazon.awscdk.CfnStackSet.AutoDeploymentProperty] = None,
    description: Option[String] = None,
    administrationRoleArn: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    stackInstancesGroup: Option[List[_]] = None,
    managedExecution: Option[AnyRef] = None,
    templateUrl: Option[String] = None,
    templateBody: Option[String] = None,
    operationPreferences: Option[software.amazon.awscdk.CfnStackSet.OperationPreferencesProperty] = None,
    parameters: Option[List[_]] = None
  ): software.amazon.awscdk.CfnStackSetProps =
    (new software.amazon.awscdk.CfnStackSetProps.Builder)
      .stackSetName(stackSetName)
      .permissionModel(permissionModel)
      .callAs(callAs.orNull)
      .executionRoleName(executionRoleName.orNull)
      .capabilities(capabilities.map(_.asJava).orNull)
      .autoDeployment(autoDeployment.orNull)
      .description(description.orNull)
      .administrationRoleArn(administrationRoleArn.orNull)
      .tags(tags.map(_.asJava).orNull)
      .stackInstancesGroup(stackInstancesGroup.map(_.asJava).orNull)
      .managedExecution(managedExecution.orNull)
      .templateUrl(templateUrl.orNull)
      .templateBody(templateBody.orNull)
      .operationPreferences(operationPreferences.orNull)
      .parameters(parameters.map(_.asJava).orNull)
      .build()
}
