package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourceDefaultVersion {

  def apply(
    internalResourceId: String,
    typeName: Option[String] = None,
    versionId: Option[String] = None,
    typeVersionArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.CfnResourceDefaultVersion =
    software.amazon.awscdk.CfnResourceDefaultVersion.Builder
      .create(stackCtx, internalResourceId)
      .typeName(typeName.orNull)
      .versionId(versionId.orNull)
      .typeVersionArn(typeVersionArn.orNull)
      .build()
}
