package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnOutputProps {

  def apply(
    value: String,
    condition: Option[software.amazon.awscdk.CfnCondition] = None,
    description: Option[String] = None,
    exportName: Option[String] = None
  ): software.amazon.awscdk.CfnOutputProps =
    (new software.amazon.awscdk.CfnOutputProps.Builder)
      .value(value)
      .condition(condition.orNull)
      .description(description.orNull)
      .exportName(exportName.orNull)
      .build()
}
