package io.burkard.cdk.core

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMapping {

  def apply(
    internalResourceId: String,
    mapping: Option[Map[String, _ <: Map[String, _]]] = None,
    `lazy`: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.CfnMapping =
    software.amazon.awscdk.CfnMapping.Builder
      .create(stackCtx, internalResourceId)
      .mapping(mapping.map(_.mapValues(_.asJava).toMap.asJava).orNull)
      .`lazy`(`lazy`.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
