package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourceVersionProps {

  def apply(
    typeName: String,
    schemaHandlerPackage: String,
    loggingConfig: Option[software.amazon.awscdk.CfnResourceVersion.LoggingConfigProperty] = None,
    executionRoleArn: Option[String] = None
  ): software.amazon.awscdk.CfnResourceVersionProps =
    (new software.amazon.awscdk.CfnResourceVersionProps.Builder)
      .typeName(typeName)
      .schemaHandlerPackage(schemaHandlerPackage)
      .loggingConfig(loggingConfig.orNull)
      .executionRoleArn(executionRoleArn.orNull)
      .build()
}
