package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileAssetLocation {

  def apply(
    s3ObjectUrl: String,
    bucketName: String,
    objectKey: String,
    httpUrl: String
  ): software.amazon.awscdk.FileAssetLocation =
    (new software.amazon.awscdk.FileAssetLocation.Builder)
      .s3ObjectUrl(s3ObjectUrl)
      .bucketName(bucketName)
      .objectKey(objectKey)
      .httpUrl(httpUrl)
      .build()
}
