package io.burkard.cdk.core

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AssetOptions {

  def apply(
    assetHash: Option[String] = None,
    bundling: Option[software.amazon.awscdk.BundlingOptions] = None,
    assetHashType: Option[software.amazon.awscdk.AssetHashType] = None
  ): software.amazon.awscdk.AssetOptions =
    (new software.amazon.awscdk.AssetOptions.Builder)
      .assetHash(assetHash.orNull)
      .bundling(bundling.orNull)
      .assetHashType(assetHashType.orNull)
      .build()
}
