package io.burkard.cdk.core

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTrafficRouting {

  def apply(
    testTrafficRoute: Option[software.amazon.awscdk.CfnTrafficRoute] = None,
    targetGroups: Option[List[String]] = None,
    prodTrafficRoute: Option[software.amazon.awscdk.CfnTrafficRoute] = None
  ): software.amazon.awscdk.CfnTrafficRouting =
    (new software.amazon.awscdk.CfnTrafficRouting.Builder)
      .testTrafficRoute(testTrafficRoute.orNull)
      .targetGroups(targetGroups.map(_.asJava).orNull)
      .prodTrafficRoute(prodTrafficRoute.orNull)
      .build()
}
