package io.burkard.cdk.services.config

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RecordingGroupProperty {

  def apply(
    resourceTypes: Option[List[String]] = None,
    allSupported: Option[Boolean] = None,
    includeGlobalResourceTypes: Option[Boolean] = None
  ): software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty =
    (new software.amazon.awscdk.services.config.CfnConfigurationRecorder.RecordingGroupProperty.Builder)
      .resourceTypes(resourceTypes.map(_.asJava).orNull)
      .allSupported(allSupported.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .includeGlobalResourceTypes(includeGlobalResourceTypes.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
