package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NumberAttributeProps {

  def apply(
    min: Option[Number] = None,
    max: Option[Number] = None,
    mutable: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.NumberAttributeProps =
    (new software.amazon.awscdk.services.cognito.NumberAttributeProps.Builder)
      .min(min.orNull)
      .max(max.orNull)
      .mutable(mutable.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .build()
}
