package io.burkard.cdk.services.cognito

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthSettings {

  def apply(
    flows: Option[software.amazon.awscdk.services.cognito.OAuthFlows] = None,
    callbackUrls: Option[List[String]] = None,
    logoutUrls: Option[List[String]] = None,
    scopes: Option[List[_ <: software.amazon.awscdk.services.cognito.OAuthScope]] = None
  ): software.amazon.awscdk.services.cognito.OAuthSettings =
    (new software.amazon.awscdk.services.cognito.OAuthSettings.Builder)
      .flows(flows.orNull)
      .callbackUrls(callbackUrls.map(_.asJava).orNull)
      .logoutUrls(logoutUrls.map(_.asJava).orNull)
      .scopes(scopes.map(_.asJava).orNull)
      .build()
}
