package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomAttributeConfig {

  def apply(
    dataType: String,
    mutable: Option[Boolean] = None,
    numberConstraints: Option[software.amazon.awscdk.services.cognito.NumberAttributeConstraints] = None,
    stringConstraints: Option[software.amazon.awscdk.services.cognito.StringAttributeConstraints] = None
  ): software.amazon.awscdk.services.cognito.CustomAttributeConfig =
    (new software.amazon.awscdk.services.cognito.CustomAttributeConfig.Builder)
      .dataType(dataType)
      .mutable(mutable.map(Boolean.box).getOrElse(java.lang.Boolean.FALSE))
      .numberConstraints(numberConstraints.orNull)
      .stringConstraints(stringConstraints.orNull)
      .build()
}
