package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserVerificationConfig {

  def apply(
    emailBody: Option[String] = None,
    emailSubject: Option[String] = None,
    emailStyle: Option[software.amazon.awscdk.services.cognito.VerificationEmailStyle] = None,
    smsMessage: Option[String] = None
  ): software.amazon.awscdk.services.cognito.UserVerificationConfig =
    (new software.amazon.awscdk.services.cognito.UserVerificationConfig.Builder)
      .emailBody(emailBody.orNull)
      .emailSubject(emailSubject.orNull)
      .emailStyle(emailStyle.orNull)
      .smsMessage(smsMessage.orNull)
      .build()
}
