package io.burkard.cdk.services.codepipeline

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudFormationExecuteChangeSetAction {

  def apply(
    stackName: String,
    changeSetName: String,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    outputFileName: Option[String] = None,
    variablesNamespace: Option[String] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None,
    region: Option[String] = None,
    account: Option[String] = None,
    output: Option[software.amazon.awscdk.services.codepipeline.Artifact] = None
  ): software.amazon.awscdk.services.codepipeline.actions.CloudFormationExecuteChangeSetAction =
    software.amazon.awscdk.services.codepipeline.actions.CloudFormationExecuteChangeSetAction.Builder
      .create()
      .stackName(stackName)
      .changeSetName(changeSetName)
      .role(role.orNull)
      .outputFileName(outputFileName.orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .region(region.orNull)
      .account(account.orNull)
      .output(output.orNull)
      .build()
}
